import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the floor and elevator characteristics
floor_height = 1
floor_width = 10
elevator_width = 1
elevator_height = 0.8
passenger_width = 0.5
passenger_height = 0.5

# Colors
floor_color = 'lightgray'
passenger_color = 'blue'
fast_elevator_color = 'green'
slow_elevator_color = 'yellow'

# Create the figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Draw floors
for i in range(5):
    floor_y = i * floor_height
    ax.add_patch(patches.Rectangle((0, floor_y), floor_width, floor_height, edgecolor='black', facecolor=floor_color))
    ax.text(0.5, floor_y + floor_height/2, f'floor_{i}', verticalalignment='center', fontsize=10, color='black')

# Draw passengers
passenger_positions = {
    0: ['p2', 'p3'],
    1: ['p0', 'p5'],
    3: ['p1', 'p4']
}
for floor, passengers in passenger_positions.items():
    for j, passenger in enumerate(passengers):
        ax.add_patch(patches.Rectangle((j * passenger_width, floor * floor_height + (floor_height - passenger_height) / 2),
                                       passenger_width, passenger_height, edgecolor='black', facecolor=passenger_color))
        ax.text(j * passenger_width + passenger_width/2, floor * floor_height + floor_height/2,
                passenger, verticalalignment='center', horizontalalignment='center', fontsize=8, color='white')

# Draw elevators
elevator_positions = {
    'fast0': (0, 0),
    'fast1': (0, 0),
    'slow0-0': (0, 0),
    'slow1-0': (2, 2)
}
for elevator, (floor, column) in elevator_positions.items():
    x_position = floor_width - (2 - column) * elevator_width
    y_position = floor * floor_height + (floor_height - elevator_height) / 2
    color = fast_elevator_color if 'fast' in elevator else slow_elevator_color
    ax.add_patch(patches.Rectangle((x_position, y_position), elevator_width, elevator_height, edgecolor='black', facecolor=color))
    ax.text(x_position + elevator_width/2, y_position + elevator_height/2,
            f'{elevator}\n0/{2 if "fast" in elevator else 1}', verticalalignment='center', horizontalalignment='center', fontsize=8, color='black')

# Create legend
legend_elements = [
    patches.Patch(facecolor=passenger_color, edgecolor='black', label='Passenger'),
    patches.Patch(facecolor=fast_elevator_color, edgecolor='black', label='Fast Elevator'),
    patches.Patch(facecolor=slow_elevator_color, edgecolor='black', label='Slow Elevator')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.2, 1))

# Set limits and hide axes
ax.set_xlim(-1, floor_width + 2)
ax.set_ylim(-1, floor_height * 5)
ax.axis('off')

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_36.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Fast elevators are not visible in the diagram.
